//--------------------------------------------------------------------------------------
// File: LovelyIntro5.fx
//--------------------------------------------------------------------------------------

///
/// config
///
#define EPSILON 0.001
#define E EPSILON
#define MAT_SILVER_ID 1.0
#define MAT_GREEN_ID 2.0
#define MAT_RED_ID 3.0
#define MAT_BLUE_ID 4.0
#define MAT_TEX_ID 5.0
#define MAT_TEX2_ID 6.0 ///@todo implement
#define MAT_YELLOW_ID 7.0
#define MAT_RED_REFLEX_ID 8.0
#define MAT_BLUE_REFLEX_ID 9.0
#define MAT_YELLOW_REFLEX_ID 10.0
#define MAT_WATER_ID 11.0
#define PI 3.14159265


SamplerState sampleType : register(s0);
Texture2D texture0 : register(t0); /// background
Texture2D texture1 : register(t1); /// perlin
Texture2D texture2 : register(t2); /// tree
Texture2D textureThunder : register(t3); /// thunder
Texture2D texture4 : register(t4);
Texture2D texture5 : register(t5);
Texture2D texture6 : register(t6);
Texture2D texture7 : register(t7);

//--------------------------------------------------------------------------------------
// Constant Buffer Variables
//--------------------------------------------------------------------------------------
cbuffer ConstantBuffer : register( b0 )
{
	matrix World;
	matrix View;
	matrix Projection;
	float atime;
	uint width;
	uint height;
	float input_a;
	float input_b;
	float input_c;
	float input_d;
	float input_e;
	///@todo delete that, it's not used any more
	int shaderMod;
	float explosionTime;
	int emiting_light;
}


//--------------------------------------------------------------------------------------
struct VS_INPUT
{
	float4 Pos : POSITION;
	float4 Color : COLOR;
	float3 Normal : NORMAL;
	float2 uv : TEXCOORD0;
};

struct PS_INPUT
{
    float4 Pos : SV_POSITION;
    float4 Color : COLOR;
	float3 Normal : NORMAL;
	float2 uv: TEXCOORD0;
};


float min( float a, float b, float c){
   return min( a, min(b, c) );
}

float max( float a, float b, float c){
   return max( a, max( b, c ) );
}


float3x3 getMatRotX(float l){
	float3x3 mat = mul( mat, float3x3(
		1.0,		0.0,		0.0, 
		0.0,		cos(l),		-sin(l),
		0.0,		sin(l),		cos(l) ) );
	return mat;

}

float3x3 getMatRotZ(float l){
	float3x3 mat= {
		cos(l),		-sin(l),	0.0, 
		sin(l),		cos(l),		0.0,
		0.0,		0.0,		1.0 };
	return mat;
}

float3 getSkyColor(in float3 dir){
	if( SHADER_MOD==13 )
	{
		float ss= 1.0;//+0.1/(0.1+dir.z);
		float4 cc= texture0.Sample( sampleType, float2(-0.5+dir.x*ss,0.4-dir.z*ss) );
		float3 r = cc.rgb/4.0;

		if( 0.0 < dir.z ){
			float s= 0.5/(dir.z);
			float4 t2= texture1.Sample( sampleType, float2(dir.x*s,dir.y*s+atime*0.1) );
			s *= 0.5;
			float4 t1= texture1.Sample( sampleType, float2(dir.x*s+0.55,dir.y*s) );
			float4 ccc= 0.5*t1+0.5*t2;
			float alpha= min(1.0,2.0*max(t1[3],t2[3]))*min(1.0,-0.1+1.5*(dir.z));
			r = (1.0-alpha)*r + alpha*ccc.xyz;
		}
		return r;
	}else{
		float4 cc= texture0.Sample( sampleType, float2(0.5+dir.x*1.0,0.4-dir.z*1.0) );
	
		//float ss= 1.0;//+0.1/(0.1+dir.z);
		//float4 cc= texture0.Sample( sampleType, float2(-0.5+dir.x*ss,0.4-dir.z*ss) );
		float3 r = cc.rgb/4.0;
		//return r;

		///@todo check is it ok in other scenes than 13
		if( 0.0 < dir.z ){
			float s= 0.5/(dir.z);
			//float4 ccc= texture1.Sample( sampleType, dir.xz*2.0 );
			//float4 ccc= texture1.Sample( sampleType, float2(dir.x*s,dir.y*s) );
			//float4 ccc= texture1.Sample( sampleType, float2(dir.x*s,dir.y*s+atime) );
			float4 t2= texture1.Sample( sampleType, float2(dir.x*s,dir.y*s+atime*0.1) );
			s *= 0.5;
			float4 t1= texture1.Sample( sampleType, float2(dir.x*s+0.55,dir.y*s) );
			float4 ccc= 0.5*t1+0.5*t2;
			//float alpha= ccc[3];
			//float alpha= min(1.0,2.0*dir.z);
			float alpha= min(1.0,2.0*max(t1[3],t2[3]))*min(1.0,8.0*(dir.z));
			//float alpha= min(1.0,2.0*max(t1[3],t2[3]))*min(1.0,-0.1+1.5*(dir.z));
			r = (1.0-alpha)*r + alpha*ccc.xyz;
		}
		return r;
	}
}

//--------------------------------------------------------------------------------------
// Vertex Shader
//--------------------------------------------------------------------------------------
PS_INPUT VS( VS_INPUT input )
{
    PS_INPUT output = (PS_INPUT)0;
	
	output.Pos= input.Pos;
	output.Normal= normalize(input.Normal);
    output.Pos = mul( output.Pos, World );
	if( 0.0 < explosionTime ){
		float3 pos = float3( output.Pos.x/output.Pos.w, output.Pos.y/output.Pos.w, output.Pos.z/output.Pos.w );
		
		float3 nor;
		{
			float4 nor4 = mul( float4(output.Normal,1.0), World );
			float4 zer4 = mul( float4(0.0,0.0,0.0,1.0), World );
			nor4.x /= nor4.w;
			nor4.y /= nor4.w;
			nor4.z /= nor4.w;
			nor4.w= 1.0;
			
			zer4.x /= zer4.w;
			zer4.y /= zer4.w;
			zer4.z /= zer4.w;
			zer4.w= 1.0;
			
			nor.x = nor4.x - zer4.x;
			nor.y = nor4.y - zer4.y;
			nor.z = nor4.z - zer4.z;
		}
		
		float h= log( explosionTime);
		pos.x += h*nor.x;
		pos.y += h*nor.y;
		
		pos.z += explosionTime*( nor.z - explosionTime );
		if( pos.z < -10.0 )
			pos.z = -10.0;
		
		output.Pos = float4(pos.x,pos.y,pos.z,1.0);
	}
    output.Pos = mul( output.Pos, View );
    output.Pos = mul( output.Pos, Projection );
    output.Color = input.Color;

	// output.Normal= (input.Normal);
    // output.Normal= normalize( mul( output.Normal, World ) );
	// output.Normal= normalize(input.Normal);
    //output.Normal = mul( output.Normal, View );
    //output.Normal = mul( output.Normal, Projection );

	// output.Tex = output.Pos.xy / width;
	output.uv = input.uv;
    
    return output;
}


//--------------------------------------------------------------------------------------
// Pixel Shader
//--------------------------------------------------------------------------------------
float4 PS( PS_INPUT input) : SV_Target
{
	//return texture0.Sample(sampleType, input.Pos.xy/width );
	//if( 0!=shaderMod )return float4( 1.0f, 1.0f, 1.0f, 1.0f);
	switch(SHADER_MOD)
	{
		/// standard 3D rendering
		case 1:{
			// return texture0.Sample(sampleType, input.uv);
			//return input.Color * ( 0.5f + 0.5f*saturate( dot( input.Normal, float3(0,0,1) ) ) );
			float4 c= texture0.Sample(sampleType, input.uv);
			float4 r;
			if( emiting_light ){
				r= input.Color * c; 
			}else{
				r= input.Color * c * (0.1+0.9*( 0.5 + 0.5*input.Normal.z )); 
			}
			// r= float4(1,1,1,1)*( 0.5f + 0.5f*input.Normal.z );
			// return input.Color * ( 0.5f + 0.5f*input.Normal.z );
			// return input.Color;
			// r= float4( 1.0f, 0.5f, 0.5f, 1.0f);
			r.a = c.a * input.Color.a;
			return r;
		}break;
		/// constant color
		case 2:{
			return float4( 1.0f, 1.0f, 1.0f, 1.0f);
		}break;
		/// skybox
		case 3:{
			return texture0.Sample(sampleType, input.uv);
		}break;
		/// loading screen
		case 9:{
			float x= input.Pos[0];
			float y= input.Pos[1];
			float4 r= float4( 0.0, 0.0, 0.0, 1.0 );
			r= texture0.Sample( sampleType, float2(x/width,y/height) );
			float ya=abs(y-height/2.0)/height;
			float xa=abs(x-width/2.0)/width;
			if( xa < 0.48 && ya < 0.1 ){
				r= float4( 1.0, 1.0, 1.0, 1.0 );
				if( xa < 0.46 && ya < 0.08 ){
					r= float4( 0.0, 0.0, 0.0, 1.0 );
					if( xa < 0.44 && ya < 0.06 ){
						if( x <= width*(0.06+input_a*0.88) )
							r= float4( 1.0, 0.0, 0.0, 1.0 );
					}
				}
			}
			return r;
		}break;
		/// texture show
		case 10:{
			// return float4( 1.0, input.Pos.y/width, 0.0, 1.0 );
			//return texture0.Sample(sampleType, float2(0.5,0.5) );
			//return texture0.Sample(sampleType, input.Tex );
			// return texture5.Sample(sampleType, input.Pos.xy/width );
			return texture5.Sample(sampleType, float2(input.Pos.x/width,input.Pos.y/height) );
			// float4 c= texture0.Sample(sampleType, float2(input.Pos.x,input.Pos.y+atime)/width );
			// return c;
			// float a= c.a;
			// if( a <= 0.0 ){
				// return float4(0.0,1.0,0.0,1.0);
			// }else{
				// return (1.0-a)*float4(1.0,0.0,0.0,1.0) + a*float4(c.xyz,1.0);
				// return (1.0-a)*float4(1.0,0.0,0.0,1.0) + a*float4(1.0,1.0,1.0,1.0);
			// }
		}break;
		default:{
			//return input.Color * ( 0.5f + 0.5f*saturate( dot( input.Normal, float3(0,0,1) ) ) );
			//return input.Color * ( 0.5f + 0.5f*input.Normal.z );
			//float3 c= float3( atime,-2.0, 1.0);
			//float3 d= normalize(float3( (input.Pos[0]*2.0-width)/width, 2.0, (height-input.Pos[1]*2.0)/width ));
			//d= dfRotateX( d, -0.7 );
			//return float4( df_render( c, d, c + float3( 0.0, 2.0, 10.0 ) ), 1.0 );
			return float4( 0.0f, 1.0f, 0.0f, 1.0f);
		}break;
	}
}
